/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.axiom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.skinsrestorer.shadow.commons.lang3.BooleanUtils;
import net.skinsrestorer.shadow.commons.lang3.math.NumberUtils;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.snakeyaml.DumperOptions;
import net.skinsrestorer.shadow.snakeyaml.Yaml;
import net.skinsrestorer.shadow.snakeyaml.nodes.MappingNode;
import net.skinsrestorer.shadow.snakeyaml.nodes.Node;
import net.skinsrestorer.shadow.snakeyaml.nodes.NodeTuple;
import net.skinsrestorer.shadow.snakeyaml.nodes.ScalarNode;
import net.skinsrestorer.shadow.snakeyaml.nodes.SequenceNode;

public class AxiomConfigurationSection {
    protected final Yaml yaml;
    protected MappingNode rootNode;

    public Node getNode(String path) {
        String[] parts = path.split("\\.");
        AxiomConfigurationSection node = this;
        int i = 0;
        for (String part : parts) {
            Node subNode = node.getDirectSubNode(part);
            if (i == parts.length - 1) {
                return subNode;
            }
            if (!(subNode instanceof MappingNode)) {
                return null;
            }
            node = new AxiomConfigurationSection(this.yaml, (MappingNode)subNode);
            ++i;
        }
        return null;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (NodeTuple tuple : this.rootNode.getValue()) {
            if (!(tuple.getKeyNode() instanceof ScalarNode)) continue;
            ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
            keys.add(keyNode.getValue());
        }
        return keys;
    }

    protected Node getKeyNodeOfSubNode(String name) {
        for (NodeTuple tuple : this.rootNode.getValue()) {
            ScalarNode keyNode;
            if (!(tuple.getKeyNode() instanceof ScalarNode) || !(keyNode = (ScalarNode)tuple.getKeyNode()).getValue().equals(name)) continue;
            return tuple.getKeyNode();
        }
        return null;
    }

    protected Node getDirectSubNode(String name) {
        for (NodeTuple tuple : this.rootNode.getValue()) {
            ScalarNode keyNode;
            if (!(tuple.getKeyNode() instanceof ScalarNode) || !(keyNode = (ScalarNode)tuple.getKeyNode()).getValue().equals(name)) continue;
            return tuple.getValueNode();
        }
        return null;
    }

    protected Node setDirectSubNode(String name, Node setKeyNode, Node setValueNode) {
        if (this.rootNode.getValue().stream().map(NodeTuple::getKeyNode).anyMatch(node1 -> node1 instanceof ScalarNode && ((ScalarNode)node1).getValue().equals(name))) {
            this.rootNode.getValue().replaceAll(tuple -> {
                ScalarNode keyNode;
                if (tuple.getKeyNode() instanceof ScalarNode && (keyNode = (ScalarNode)tuple.getKeyNode()).getValue().equals(name)) {
                    if (setKeyNode != null) {
                        return new NodeTuple(setKeyNode, setValueNode);
                    }
                    return new NodeTuple(keyNode, setValueNode);
                }
                return tuple;
            });
        } else if (setKeyNode != null) {
            this.rootNode.getValue().add(new NodeTuple(setKeyNode, setValueNode));
        } else {
            this.rootNode.getValue().add(this.createTuple(name, setValueNode));
        }
        return null;
    }

    public AxiomConfigurationSection getSection(String path) {
        Node node = this.getNode(path);
        if (node instanceof MappingNode) {
            return new AxiomConfigurationSection(this.yaml, (MappingNode)node);
        }
        return null;
    }

    public String getString(String path) {
        Node node = this.getNode(path);
        if (node instanceof ScalarNode) {
            return ((ScalarNode)node).getValue();
        }
        return null;
    }

    public Integer getInt(String path) throws NumberFormatException {
        String value = this.getString(path);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public Boolean getBoolean(String path) {
        String value = this.getString(path);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public List<String> getStringList(String path) {
        Node node = this.getNode(path);
        if (node instanceof SequenceNode) {
            ArrayList<String> list = new ArrayList<String>();
            SequenceNode sequenceNode = (SequenceNode)node;
            for (Node valueNode : sequenceNode.getValue()) {
                if (!(valueNode instanceof ScalarNode)) continue;
                ScalarNode scalarNode = (ScalarNode)valueNode;
                list.add(scalarNode.getValue());
            }
            return list;
        }
        return null;
    }

    public void set(String path, Object value) {
        String[] parts = path.split("\\.");
        String target = parts[parts.length - 1];
        String parentPath = path.substring(0, path.length() - target.length());
        NodeTuple keyNode = null;
        Node parentNode = this.getNode(parentPath);
        if (parentNode instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)parentNode;
            for (NodeTuple tuple : mappingNode.getValue()) {
                ScalarNode scalarKeyNode;
                if (!(tuple.getKeyNode() instanceof ScalarNode) || !(scalarKeyNode = (ScalarNode)tuple.getKeyNode()).getValue().equals(target)) continue;
                keyNode = tuple;
            }
        }
        this.set(path, value == null ? null : this.createTuple(target, value, keyNode));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(String path, NodeTuple value) {
        String[] parts = path.split("\\.");
        try {
            MappingNode node = this.rootNode;
            int i = 0;
            for (String part : parts) {
                if (i < parts.length - 1) {
                    Optional<NodeTuple> optionalTuple = node.getValue().stream().filter(tuple -> {
                        if (tuple.getKeyNode() instanceof ScalarNode) {
                            ScalarNode scalarKeyNode = (ScalarNode)tuple.getKeyNode();
                            return scalarKeyNode.getValue().equals(part);
                        }
                        return false;
                    }).findFirst();
                    if (optionalTuple.isPresent()) {
                        if (!(optionalTuple.get().getValueNode() instanceof MappingNode)) throw new Exception("Invalid node type");
                        node = (MappingNode)optionalTuple.get().getValueNode();
                    } else {
                        MappingNode newMapping = (MappingNode)this.yaml.represent(Collections.emptyMap());
                        node.getValue().add(this.createTuple(part, newMapping));
                        node = newMapping;
                    }
                } else if (value != null) {
                    if (node.getValue().stream().anyMatch(nodeTuple -> {
                        if (nodeTuple.getKeyNode() instanceof ScalarNode) {
                            ScalarNode scalarKeyNode = (ScalarNode)nodeTuple.getKeyNode();
                            return scalarKeyNode.getValue().equals(part);
                        }
                        return false;
                    })) {
                        node.getValue().replaceAll(nodeTuple -> {
                            ScalarNode scalarKeyNode;
                            if (nodeTuple.getKeyNode() instanceof ScalarNode && (scalarKeyNode = (ScalarNode)nodeTuple.getKeyNode()).getValue().equals(part)) {
                                AxiomConfigurationSection.setComments(value.getKeyNode(), nodeTuple.getKeyNode(), false);
                                AxiomConfigurationSection.setComments(value.getValueNode(), nodeTuple.getValueNode(), false);
                                return value;
                            }
                            return nodeTuple;
                        });
                    } else {
                        node.getValue().add(value);
                    }
                } else {
                    node.getValue().removeIf(tuple -> {
                        if (tuple.getKeyNode() instanceof ScalarNode) {
                            ScalarNode scalarKeyNode = (ScalarNode)tuple.getKeyNode();
                            return scalarKeyNode.getValue().equals(part);
                        }
                        return false;
                    });
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void merge(AxiomConfigurationSection defaultConfig) {
        this.merge(defaultConfig, false, true, false);
    }

    public void merge(AxiomConfigurationSection defaultConfig, boolean overWriteComments, boolean overWriteInvalid, boolean overWrite) {
        AxiomConfigurationSection.setComments(this.rootNode, defaultConfig.rootNode, overWriteComments);
        for (String key : defaultConfig.getKeys()) {
            Node defaultNode = defaultConfig.getDirectSubNode(key);
            Node defaultParentNode = defaultConfig.getKeyNodeOfSubNode(key);
            Node currentNode = this.getDirectSubNode(key);
            if (currentNode == null || overWrite) {
                this.setDirectSubNode(key, defaultParentNode, defaultNode);
                continue;
            }
            AxiomConfigurationSection.setComments(currentNode, defaultNode, overWriteComments);
            if (!(defaultNode instanceof MappingNode)) continue;
            if (currentNode instanceof MappingNode) {
                AxiomConfigurationSection childDefaultSection = new AxiomConfigurationSection(this.yaml, (MappingNode)defaultNode);
                AxiomConfigurationSection childCurrentSection = new AxiomConfigurationSection(this.yaml, (MappingNode)currentNode);
                childCurrentSection.merge(childDefaultSection, overWriteComments, overWriteInvalid, overWrite);
                continue;
            }
            if (!overWriteInvalid) continue;
            this.setDirectSubNode(key, defaultParentNode, defaultNode);
        }
    }

    protected static void setComments(Node currentNode, Node defaultNode, boolean overWrite) {
        if (overWrite) {
            currentNode.setBlockComments(defaultNode.getBlockComments());
            currentNode.setInLineComments(defaultNode.getInLineComments());
            currentNode.setEndComments(defaultNode.getEndComments());
        } else {
            if (currentNode.getBlockComments() == null) {
                currentNode.setBlockComments(defaultNode.getBlockComments());
            }
            if (currentNode.getInLineComments() == null) {
                currentNode.setInLineComments(defaultNode.getInLineComments());
            }
            if (currentNode.getEndComments() == null) {
                currentNode.setEndComments(defaultNode.getEndComments());
            }
        }
    }

    private NodeTuple createTuple(Node key, Object value, @Nullable NodeTuple previousTuple) {
        if (value instanceof String) {
            if (NumberUtils.isParsable((String)value)) {
                value = NumberUtils.createNumber((String)value);
            } else if (BooleanUtils.toBooleanObject((String)value) != null) {
                value = BooleanUtils.toBoolean((String)value);
            }
        }
        return this.createTuple(key, this.yaml.represent(value), previousTuple);
    }

    private NodeTuple createTuple(Object key, Node value) {
        return this.createTuple(this.yaml.represent(key), value, null);
    }

    private NodeTuple createTuple(Node key, Node value, @Nullable NodeTuple previousTuple) {
        if (previousTuple != null) {
            AxiomConfigurationSection.setComments(key, previousTuple.getKeyNode(), true);
            AxiomConfigurationSection.setComments(value, previousTuple.getValueNode(), true);
        }
        if (value instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)value;
            int i = 0;
            for (Node node : new ArrayList<Node>(sequenceNode.getValue())) {
                if (node instanceof ScalarNode) {
                    ScalarNode scalarNode = (ScalarNode)node;
                    sequenceNode.getValue().set(i, new ScalarNode(scalarNode.getTag(), scalarNode.getValue(), scalarNode.getStartMark(), scalarNode.getEndMark(), DumperOptions.ScalarStyle.DOUBLE_QUOTED));
                }
                ++i;
            }
        }
        return new NodeTuple(key, value);
    }

    private NodeTuple createTuple(Object key, Object value, @Nullable NodeTuple previousTuple) {
        return this.createTuple(this.yaml.represent(key), value, previousTuple);
    }

    public AxiomConfigurationSection(Yaml yaml, MappingNode rootNode) {
        this.yaml = yaml;
        this.rootNode = rootNode;
    }
}

